\name{ntStep}
\alias{ntStep}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Compute the Newton Step on Grassmannian
}
\description{
  Computes the Newton step for a function on the Grassmann manifold that should
  be minimized.
}
\usage{
ntStep(y,f,fy,fyy,ltol = 1e-3)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y}{starting point on Gr(n,p), represented by an n \eqn{\times}{x} p 
    matrix.}
  \item{f}{the value of \code{f} at \code{y}.}
  \item{fy}{the gradient of \code{f} at \code{y} with respect to each element in the input
    matrix. fy should be an n \eqn{\times}{x} p matrix.}
  \item{fyy}{the Hessian of \code{f} at \code{y} with respect to each element in the input
    matrix. This means that fyy should be a
    np \eqn{\times}{x} np matrix where the element in place 
    ((j-1)n + i,(l-1)n + k) is
    \deqn{\frac{\partial^2 f}{\partial y_{ij} \partial y_{kl}}}{
          d^2f/dy_{ij}dy_{kl}}}
  \item{ltol}{The smallest eigenvalue of the Hessian that is tolerated. If
              the Hessian has an eigenvalue smaller than this (if it is not
              positive definite), a multiple of the identity matrix is added to
              the Hessian so that the resulting matrix has ltol as its smallest
              eigenvalue.}
}
\details{
  The Newton step is \eqn{v = \Pi(B^{-1}\nabla f)}{v = Pi(B^-1 grad f)}, where
  \eqn{\Pi}{Pi} is the projection onto the tangent plane, 
  \eqn{B = Hess(f) + \epsilon I}{B = Hess(f) + cI}, \eqn{Hess(f)} is a matrix
  interpretation of the Hessian of \code{fun} on Gr(n,p), \eqn{\epsilon}{c} is 
  chosen such that the smallest eigenvalue of \eqn{B} is \code{ltol} and
  \eqn{\nabla f}{grad f} is the gradient of \code{fun} along the Gr(n,p). For
  further information, see the reference and the package vignette.
}
\value{
  An element v in the tangent space, i.e. an n \eqn{\times}{x} p matrix such
  that \eqn{y^Tv = 0}{y'v = 0}
}
\references{
  Edelman, A., Arias, T. A., and Smith S. T. (1998) The geometry of
  algorithms with orthogonality constraints. \emph{SIAM J. Matrix Anal. Appl.},
  \bold{20}(2), 303-353.
}
\author{
  Kerstin Johnsson, Lund University.
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
 \code{\link{optgr}}
}
%\examples{
%##---- Should be DIRECTLY executable !! ----
%##-- ==>  Define data, use random,
%##--	or do  help(data=index)  for the standard data sets.
%
%## The function is currently defined as
%.Primitive("missing")
%}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
