\name{grassopt-package}
\alias{grassopt-package}
\alias{grassopt}
\docType{package}
\title{
Optimization over Grassmannian
}
\description{
Provides functions to do optimization over a Grassmann manifold with Newton's
method or the gradient descent method.
}
\details{
\tabular{ll}{
Package: \tab grassopt\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2012-07-04\cr
License: \tab GPL (>= 2) \cr
LazyLoad: \tab yes\cr
}
The function \code{optgr} can be used to minmize a function over a Grassmann
manifold. The function \code{ntStep} computes the Newton step for Newton's
method, and the function \code{geod} moves a point along a geodesic along the
Grassmann manifold. For details on how the Newton step is computed, see the
package vignette \"Optimization over Grassmann manifolds\".
}
\author{
Kerstin Johnsson, Lund University

Maintainer: Kerstin Johnsson <johnsson@maths.lth.se>
}
\references{
  Edelman, A., Arias, T. A., and Smith S. T. (1998) The geometry of
  algorithms with orthogonality constraints. \emph{SIAM J. Matrix Anal. Appl.},
  \bold{20}(2), 303-353.
}
\keyword{ package }
\seealso{
}
%\examples{
%n <- 20
%p <- 4
%
%A <- matrix(runif(n^2), n, n)
%A <- (A + t(A))/2
%
%f1 <- function(y) sum(diag(t(y) \%*\% A \%*\% y))/2
%f1y <- function(y) (A + t(A)) \%*\% y/2
%f1yy <- function(y) {
%  B <- matrix(0, n*p, n*p)
%  for (j in 1:p) {
%    B[((j-1)*n + 1):(j*n),((j-1)*n + 1):(j*n)] <- A
%  }
%  return(B)
%}
%
%y0 <- rbind(diag(1, p), matrix(0, n-p, p))
%ntf1 <- optgr(y0, f1, f1y, f1yy)
%
%par(mfrow = c(1, 2))
%plot(sapply(ntf1$y, f1), type = 'l', ylab = 'F(Y)', xlab = 'Iteration')
%optval <- sum(sort(eigen(A, only.values = TRUE)$values)[1:p])/2
%abline(h = optval, lty = 2)
%print(optval)
%err <- abs(sapply(ntf1$y, f1) - optval)
%plot(err, log = 'y', ylab = 'Absolute error', xlab = 'Iteration')
%
%}
