\name{geod}
\alias{geod}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Move Along a Geodesic on Grassmannian
}
\description{
  Move from a point on the Grassmann manifold Gr(n,p) represented by an 
  n \eqn{\times}{x} p matrix \code{y} along the geodesic in the 
  direction \code{v}.
}
\usage{
geod(y,v,r = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y}{the point from where the geodesic start, an n \eqn{\times}{x} p 
    matrix.}
  \item{v}{the direction of the geodesic, an n \eqn{\times}{x} p matrix.}
  \item{r}{the step size}
}
\details{
  Each point on the Grassmannian is represented by a n \eqn{\times}{x} p 
  matrix \eqn{y}. \eqn{y} should be orthonormal, i.e. \eqn{y^Ty = I}{y'y = I}. The 
  columns in \eqn{y} together form an orthonormal basis for the p-dimensional 
  subspace of \eqn{\mathbf{R}^n}{Rn} that is intended. \eqn{v} should be in
  the tangent space of Gr(n,p) at \eqn{y}, i.e. \eqn{y^Tv = 0}{y'v = 0}. If
  \eqn{v} is not in the tangent space, it is projected onto it and a warning is
  given.

  The update is done according to
  \deqn{y(r) = (yV \; U)\left( \begin{array}{l} \cos(\Sigma r) \\ \sin(\Sigma r) \\
  \end{array} \right) V^T}{ 
        y(r) = (yV U)(cos(Sr) sin(Sr))' V'}
  where \eqn{v = U\Sigma V^T}{v = USV'} is the compact singular value
  decomposition of v.
}
%\value{
%%%  ~Describe the value returned
%%%  If it is a LIST, use
%%%  \item{comp1 }{Description of 'comp1'}
%%%  \item{comp2 }{Description of 'comp2'}
%%% ...
%}
\references{
  Edelman, A., Arias, T. A., and Smith S. T. (1998) The geometry of
  algorithms with orthogonality constraints. \emph{SIAM J. Matrix Anal. Appl.},
  \bold{20}(2), 303-353.
}
\author{
  Kerstin Johnsson, Lund University.
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
y <- rbind(diag(1, 3), matrix(0, 2, 3))
v <- rbind(diag(0, 3), matrix(runif(6), 2, 3))
t(y) \%*\% v # This being zero shows v is a tangent
y2 <- geod(y, v, 5)
max(abs(t(y2) \%*\% y2 - diag(1, 3)))


v <- (diag(1,nrow(y2)) - y2\%*\%t(y2)) \%*\% matrix(runif(15), 5, 3)
y2 <- geod(y2, v, 4)
max(abs(t(y2) \%*\% y2 - diag(1, 3))) # This shows how much the result deviates
                                      # from being orthonormal


}
%% Add one or more standard keywords, see file 'KEYWORDS' in the
%% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
