optgr <- function(y0, fun, grEu, hessEu = NULL,
                  maxit = 50, tol = 1e-8, ltol = 1e-3,
                  alpha = 0.2, beta = 0.5) {
                     
  if(is.null(hessEu)) steep.desc <- TRUE 
  else steep.desc <- FALSE
  
  y <- list()
  lam2 <- rep(NA, maxit)
  
  y[[1]] <- y0
  n <- nrow(y0)
  
  for (iter in 1:maxit) {
    yy <- y[[iter]]
    grEuy <- grEu(yy)
    gr <- (diag(1, n) - yy %*% t(yy)) %*% grEuy
    if (steep.desc) v <- -gr
    else v <- ntStep(yy, fun(yy), grEuy, hessEu(yy), ltol = ltol)
    lam2[iter] <- -sum(v*gr)
    if ((lam2[iter] < 2*tol)) break
    fyy <- fun(yy)
    r <- 1
    it <- 0
    while (fun(geod(yy, v, r)) >= fyy - alpha*r*lam2[iter]) {
      r <- beta*r
      it <- it + 1
      if (it > 20) break
    }
    if (it > 20) {
      warning("Line search failed")
      break # Stop if line search fails
    }
    y[[iter + 1]] <- geod(yy, v, r)
    
  }
  
  return(list(value = fun(y[[iter]]), y = y, lam2 = lam2))

}