ntStep <- function(y, f, fy, fyy, ltol = 1e-3) {

  n <- nrow(y)
  p <- ncol(y)
  
  ty <- t(y)
  pit <- diag(1, n) - y %*% ty
  tpit <- t(pit)
  tpitpit <- tpit %*% pit
  
  b <- -pit %*% fy
  
  dim(b) <- c(n*p, 1)
  A <- matrix(0, n*p, n*p)
  
  B <- ty %*% fy;
  B <- (B + t(B))/2 # Ensure that the Hessian is symmetric
  
  for (j in 1:p) {
    for (l in 1:p) {
      flj <- fyy[(j-1)*n + (1:n), (l-1)*n + (1:n)]
      a1 <- tpit %*% flj %*% pit
      a2 <- B[l,j] * tpitpit
      A[(j-1)*n + (1:n), (l-1)*n + (1:n)] <- a1 - a2
    }
  }
  
  lam <- min(eigen(A, only.values = TRUE)$values)
  #cat('Min eigval. of Hessian: ', lam ,'\n')
  if (lam <= ltol) A <- A + diag(ltol - lam, n*p)
  
  v <- solve(A, b)
  dim(v) <- c(n, p)
  v <- pit %*% v
  return(v)
  
}