geod <- function(y, v, r = 1) {

  if (max(abs(t(y) %*% v)) > 1e-6) warning('v not a tangent vector')

  v <- (diag(1,nrow(y)) - y%*%t(y)) %*% v
  v.svd <- svd(v)
  cbind(y %*% v.svd$v, v.svd$u) %*% rbind(diag(cos(v.svd$d*r)),
                                          diag(sin(v.svd$d*r))) %*% t(v.svd$v)
                                          
}
