\name{cuthsphere}
\alias{cuthsphere}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Piece of Noisy Hypersphere }
\description{
  Generates \code{Ns} data points cut out from a noisy hypersphere. \code{n}
  has to be at least \code{d+1}, otherwise the function terminates with an
  error.
}
\usage{
cuthsphere(Ns, rat, d, n, sd)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Ns}{ number of data points. }
  \item{rat}{ ratio between cut-off radius and radius of sphere. }
  \item{d}{ (intrinsic) dimension of hypersphere. }
  \item{n}{ dimension of noise. }
  \item{sd}{ standard deviation of noise. }
}
\details{
  The returned data are within distance \code{rat} the point
  \eqn{1/\sqrt{d+1}(1 ... 1)} and are obtained from a unit distribution on the
  \code{d}-sphere overlaid with \code{n}-dimensional normal noise.
  
  The data generated by this function can be used to evaluate the performance
  of local dimension estimators.
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
  Kerstin Johnsson, Lund University
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~
\section{Warning}{ 
  If \code{sd} is high, \code{cuthsphere} will be slow and might not even
  be able to return a data set. If so, it will return \code{NULL}.
}

\seealso{
\code{\link{cuthplane}}
}
\examples{
datap <- cuthsphere(100, rat = .5, 1, 3, 0.01)
par(mfrow = c(1, 2))
plot(datap[, 1], datap[, 2])
plot(datap[, 1], datap[, 3])

datap <- cuthsphere(100, rat = 2, 1, 3, 0.11)
par(mfrow = c(1, 2))
plot(datap[, 1], datap[, 2])
plot(datap[, 1], datap[, 3])
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ datagen }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
