\name{Spherical}
\alias{hball}
\alias{hsphere}
\alias{normal}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Isotropic distributions with or without noise }
\description{
  Generates a sample from isotropic distributions in \code{d} dimensions with
  \code{n}-dimensional noise added to it.
}
\usage{
hball(Ns, d, n = d, sd = 0)
hsphere(Ns, d, n = d + 1, sd = 0)
normal(Ns, d, n = d, sd = 0)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Ns}{ number of points. }
  \item{d}{ intrinsic dimension of the support of the distribution 
            (the manifold.) }
  \item{n}{ dimension of noise. }
  \item{sd}{ standard deviation of noise. }
}
\details{
  \code{hball} draws a sample from a uniform distribution on a hyperball of 
  radius 1.
  \code{hsphere} draws a sample from a uniform distribution on a hypersphere
  of radius 1.
  \code{normal} draws a sample from a isotropic normal distribution with
  identity covariance matrix.
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
  Kerstin Johnsson, Lund University
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
datap <- hsphere(100, 1, 3, sd = .1)
par(mfrow = c(1, 2))
plot(datap[, 1], datap[, 2])
plot(datap[, 1], datap[, 3])    

}
\keyword{ datagen }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
