\name{lpca}
\alias{lpca}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Local Dimension Estimation with PCA }
\description{
  Estimates manifold dimension using the largest singular values of the covariance matrix.
}
\usage{
lpca(data, ver, alphaFO = .05, alphaFan = 10, betaFan = .8, PFan = .95,
     ngap = 5, maxdim = min(dim(data)), verbose = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{ a local data set for which dimension should be estimated.}
  \item{ver}{ possible values: 'FO', 'fan', 'maxgap', 'cal'. 'cal' is often very slow. }
  \item{alphaFO}{ only for ver = 'FO'. An eigenvalue is considered significant if it is larger than alpha times the largest eigenvalue. }
  \item{alphaFan}{ only for ver = 'Fan'. The alpha parameter (large gap threshold).}
  \item{betaFan}{ only for ver = 'Fan'. The beta parameter (total covariance threshold).}
  \item{PFan}{ only for ver = 'Fan'. Total covariance in non-noise.}
  \item{ngap}{ only for ver = cal. The number of gaps for which likelihood should be calculated. }
  \item{maxdim}{ only for ver = 'cal'. The maximal manifold dimension of the data. }
  \item{verbose}{ should information about the process be printed out? }
}
\details{
  Version 'FO' is the method by Fukunaga-Olsen, 'fan' is the method by Fan et al., 'maxgap' returns the largest relative gap in the singular values, 'cal' is a calibrated version.
}
\value{
A list with two components
\item{de}{the dimension estimate and}
\item{gap.size}{if ver != cal; the size of the gap in singular values corresponding to the estimated dimension}
\item{likelihood}{if ver = cal; the likelihood of the estimated dimension.}
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
  Kerstin Johnsson, Lund University
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
library(manifgen)
data <- cuthplane(100, 4, 10, .05)
lpca(data, 'fan')
lpca(data, 'FO')
lpca(data, 'maxgap')

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
