################################################################################
# Functions:
#
#   ESS_de
#   ESS
#   asymval
#   interp
#   vnball
#   vnsphere
#
################################################################################

ESS <- function(data, verbose = FALSE, ver, d = 1, maxdim = 20) {
  essval <- ESS_de(data, verbose, ver, d)
  if (is.na(essval)) return(c(de = NA, ess = NA))
  dimval <- asymval(ver, d, maxdim)
  de <- interp(essval, dimval)
  return(c(de = de, ess = essval))
}

################################################################################

ESS.interpol <- function(essval, ver, d = 1, maxdim = 20) {
  dimval <- asymval(ver, d, maxdim)
  de <- interp(essval, dimval)
  return(de)
}

################################################################################

ESS_de <- function(data, verbose = FALSE, ver, d = 1) {

  p <- d + 1

  n <- dim(data)[2]
  if (p > n) {
    if (ver == 's') return(0)
    if (ver == 'c') return(1)
    stop('Not a valid version')
  }
  
  vectors <- vecToCs_onedir(data, 1)  
  if (verbose) {
    message('Number of vectors:', dim(vectors)[1], '\n')
  }
  groups <- indnComb(dim(vectors)[1], p)
  if (dim(groups)[1] > 5000) groups <- groups[sample(1:dim(groups)[1], 5000), ]
  if (verbose) {
    message('Number of simple elements:', dim(groups)[1], '\n')
  }
  Allist <- apply(groups, 1, function(row) { list(vectors[row, ]) })
  Alist <- lapply(Allist, function(el) { el[[1]] })
  
  # Compute weights for each simple element
  weight <- sapply(Alist, function(vecgr) { prod(lens(vecgr)) } )
  if (ver == 's') {
    # Compute the volumes of the simple elements
    vol <- sapply(Alist, function(vecgr) { sqrt(det(vecgr %*% t(vecgr))) } )
    return(sum(vol)/sum(weight))
  }
  if (ver == 'c') {
    if (d == 1) {
      # Compute the projection of one vector onto one other
      proj <- sapply(Alist, function(vecgr) { abs(sum(vecgr[1, ] * vecgr[2, ])) } )
      return(sum(proj)/sum(weight))
    }
    stop('For ver == "c", d > 1 is not supported.')
  }
  stop('Not a valid version')
}

################################################################################

asymval <- function(ver, d, maxdim) {
  
  if (ver == 's') {
    if (d == 1) {
      n <- 2:maxdim
      dim.val <- gamma(n/2)^2/(gamma((n-1)/2)*gamma((n+1)/2))
      return(c(0, dim.val))
    } else {
      n <- (d+1):maxdim
      dim.val <- (gamma(n/2)/gamma((n+1)/2))^d*gamma(n/2)/gamma((n-d)/2)
      return(c(rep(0, d), dim.val))
    }
#     if (d == 2) {
#       n <- 3:maxdim
#       dim.val <- gamma(n/2)^2/(gamma((n-1)/2)*gamma((n+1)/2))*(n-2)/(n-1)
#       return(c(0, 0, dim.val))  
#     } 
#     return(NA)
  } 
  if (ver == 'c') {
    if (d == 1) {
      n <- 1:maxdim
      return(2*vnball(n-1)/vnsphere(n-1))
    }
    stop('For ver == "c", d > 1 is not supported.')
  }
  stop('Not a valid version')

}
################################################################################

interp <- function(emp.val, dim.val) {

  if (is.na(dim.val[1])) return(NA)
  if (dim.val[4] <= dim.val[5]) high <- ((1:length(dim.val))[emp.val < dim.val])[1]
  else high <- ((1:length(dim.val))[emp.val > dim.val])[1]
  low <- high - 1
  diff <- (emp.val-dim.val[low])/(dim.val[high]-dim.val[low])
  return(low + diff)
  
}

################################################################################

vnball <- function(n) return(pi^(n/2)/gamma(n/2+1))
vnsphere <- function(n) return((n+1)*vnball(n+1))

################################################################################
