\name{ESS.interpol}
\alias{ESS.interpol}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Interpolation of Dimension Estimate from ESS-value
}
\description{
Takes an ESS-value returned by the ESS dimension estimation algorithm and returns an
interpolated dimension estimate.
}
\usage{
ESS.interpol(essval, ver, d = 1, maxdim = 20)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{essval}{ ESS-value returned by the ESS dimension estimation algorithm.}
  \item{ver}{ Possible values: 's' and 'c'. }
  \item{d}{ For ver = 's', any value of d is possible, for ver = 'c', only d = 1 is supported. }
  \item{maxdim}{ The maximal dimension the data could have. Used for interpolation.}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
The interpolated dimension estimate.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
Kerstin Johnsson, Lund University
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
library(manifgen)
data <- hball(100, 100)
de.data <- ESS(data, ver = 's', d = 1)
ESS.interpol(de.data['ess'], ver = 's', d = 1, maxdim = 150)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
