\name{DANCo}
\alias{DANCo}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Dimension estimation with the DANCo or MIND methods
}
\description{
  Intrinsic dimension estimation with the DANCo (Ceruti et al. 2012),
  MIND_MLi and MIND_MLk (Rozza et al. 2012) methods.
}
\usage{
DANCo(data, k, D, ver = "DANCo", cal = NULL, caldir = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{ a data set for which the intrinsic dimension is estimated. }
  \item{k}{ neighborhood parameter. }
  \item{D}{ maximal dimension. }
  \item{ver}{ possible values: 'DANCo', 'MIND_MLi', 'MIND_MLk'. }
  \item{cal}{ precomputed data to use for calibration. }
  \item{caldir}{ directory where calibration data is located. }
}
\details{
If \code{cal = NULL} and \code{caldir = NULL} new calibration data is computed. If \code{caldir = NULL}, then if \code{caldir} contains calibration data it is used, otherwise calibration data is computed and stored in \code{caldir}.
%%  ~~ If necessary, more details than the description above ~~
}
\value{
A vector with one component
  \item{de}{the intrinsic dimension estimate.}
  \item{kl}{the KL divergence between data and reference data for the estimated dimension.}
%% ...
}
\references{
  Ceruti, C. et al. (2012) DANCo: Dimensionality from Angle and Norm Concentration.
  \emph{arXiv preprint} 1206.3881.
  
  Rozza, A et al. (2012) Novel high intrinsic dimensionality estimators. \emph{Machine learning}
  \bold{89}, 37-65.
}
\author{
  Kerstin Johnsson, Lund University
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
library(manifgen)
data <- hball(50, 10)
DANCo(data, 8, 20)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
