function a_est = pseudoLS(y,freqMat,t,fs)
% Pseudo LS-estimat av komplexa amplitudvektorn a_est. Skattar komplexa
% amplituder hrande till unika frekvenser i freqMat och duplicerar dessa
% estimat p alla element i a_est som hr till samma frekvens. Avsett fr
% initialisering av PEBSI-light.
% INPUT
%   y       -       datavektor
% freqMat   -       matris innehllandes alla frekvenser i
%                   pitch-dictionaryt. Storlek Lmax -x- P
% OUTPUT
% a_est     -       estimerade komplexa frekvsener hrande till
%                   frekvenserna i freqMat. Storlek Lmax*P -x- 1

N = length(y);
freqGrid = freqMat(:);
[freqUnique,IFU,IFG] = unique(freqGrid);
W = exp(2i*pi*t(:)*freqUnique.'/fs)/sqrt(N);

a_unique = pinv(W)*y;
a_est = a_unique(IFG);

end