function [fk_adjust,fk_orig] = nls_adjustment_constrained(y,t,fs,solution,fpgrid,Lmax)
% Non-linear least squares method for adjusting pitch frequency estimates.
%
% INPUT
% y                 -       signal (complex valued).
% t                 -       time vector, in sample indices.
% fs                -       sampling frequency.
% solution          -       solution vector of dimension P*Lmax
%                           containing the full solution for the pitch
%                           frequency grid.
% fpgrid            -       vector of size P containing all pitch frequency
%                           candidates.
% Lmax              -       the maximum number of harmonics for each pitch.
% 
% OUTPUT
% fk_adjust         -       estimated pitch frequencies, adjusted using
%                           NLS.
% fk_orig           -       original pitch frequency estimates, before
%                           adjustment.


P = length(fpgrid);
sol_reshape = reshape(solution,Lmax,P);

nonzero_pitches = find(norms(sol_reshape,2,1)>0);
fk_pitches = fpgrid(nonzero_pitches);

harm_vecs = cell(1,length(fk_pitches));
for kk = 1:length(fk_pitches)
    temp_harm = find(abs(sol_reshape(:,nonzero_pitches(kk)))>0)';
    harm_vecs{kk} = temp_harm;
end

freqs_out = fminsearch(@(params)frequency_obj(y,t,fs,params,harm_vecs),fk_pitches);
fk_adjust = freqs_out;

fk_orig = fk_pitches;    
end

function val = frequency_obj(y,t,fs,fk,harm_vecs)
    freq_vec = [];
    for ll=1:length(fk)
        freq_vec = [freq_vec,fk(ll)*harm_vecs{ll}];
    end
    B = exp(2i*pi*t(:)*freq_vec(:).'/fs);
    val = -abs(y'*B*pinv(B)*y);
end