function fpgrid = map_to_grid(est_grid,large_grid)
% Maps estimated gridpoints to a finely spaced pre-defined frequency grid
% for better robustness.
%
% INPUT
% est_grid              -   estimated frequency grid points obtained using
%                           sinusoid estimators, e.g., ESPRIT.
% large_grid            -   predefined frequency grid. Choose this to be
%                           finely spaced in frequency.
%
% OUTPUT
% fpgrid                -   the resulting grid of pitch frequency
%                           candidates.
%

Pe = length(est_grid);
fpgrid = [];
for kk = 1:Pe
    gridPoint = est_grid(kk);
    [delta,temp_ind] = min(abs(gridPoint-large_grid));
    if delta>0.03*gridPoint
        continue
    end
    fpgrid = [fpgrid,large_grid(temp_ind:temp_ind)];
end
fpgrid = sort(unique(fpgrid));
end