function sigma2hat = get_sigma2hat(W,freqMat,x,y)
% Computes an unbiased estimate of the residual variance from the ADMM
% solution x. Uses only the estimated support of x (i.e. its nonzero
% indices) and produces a least square estimate using only unique columns
% of W.
%
% INPUT
% W                 -   dictionary matrix.
% freqMat           -   matrix containing the frequencies of all considered
%                       harmonics.
% x                 -   solution vector.
% y                 -   signal, complex valued.
%

% Get columns of W corresponding to active elements of x such that all
% frequencies are unique
freqMatVec = freqMat(:);
active_freqs = freqMatVec(abs(x)>0);
Wtemp = W(:,abs(x)>0);
[F,IW,IF] = unique(active_freqs);
Wtemp=Wtemp(:,IW);

% Compute least squares solution
xLS = Wtemp \ y;

% Residual
ehat = y - Wtemp*xLS;

% Compute residual variance
sigma2hat = var(ehat);
end