function [freqMatAdj,Lk_est] = adjust_freqMat(freqMat,est_freqs,tol)
% Adjusts the frequencies of the harmonics of the candidate pitches for
% better correspondence to the observed frequency content of the signal.
% Also estimates the number of active harmonics, Lk, for each candidate
% pitch.
%
% INPUT
%   freqMat         -       matrix containing the frequencies of all
%                           harmonics. Size Lmax-times-P where Lmax is the
%                           maximum number of considered harmonics for each
%                           pitch and P is the number of candidate pitches.
%   est_freqs       -       vector containing all estimated sinusoidal
%                           frequenices in the signal.
%   tol             -       tolerance for mapping a frequency in freqMat to
%                           a frequency in est_freqs.
% OUTPUT
%   freqMatAdj      -       Adjusted frequency matrix of size Lmax-times-P
%

[Lmax,P] = size(freqMat);
K = length(est_freqs);
Lk_est = ones(1,P);

freqMatAdj = freqMat;

for pp = 1:P
    for ll=1:Lmax
        origFreq = freqMat(ll,pp);
        for kk=1:K
            [delta,~] = min(abs(origFreq-est_freqs(kk)));
            if delta < tol*ll
                Lk_est(pp) = ll;
                freqMatAdj(ll,pp) = est_freqs(kk);
                break
            end
        end
    end
end
end