clc,clear,close all
%% Example script for PEBSI-Lite
%
% This script illustrates the use of PEBSI-Lite. signalData.mat allows
% for the construction of signals with up to four pitches, sampled at
% frequency 22kHz in a 30ms window.
%
% CONTENTS OF signalData
% yCell                 -       cell with four fields where each field is a
%                               single-pitch signal.
% F0s                   -       4-times-1 vector with the fundamental 
%                               frequencies of the four pitches.
% harmonicAmplitudes    -       cell with four fields where each field
%                               contains the magnitudes of the harmonics
%                               for each of the four pitches.
% fs                    -       the sampling frequency, in Hz.
% timeFrame             -       length of the window, in seconds.
%
%%
load signalData

% Choose number of sources for the signal, 1-4
nbrOfSources = 3;
indices = randperm(4,nbrOfSources);

% Construct the signal
y = 0;
trueF0s = signalData.F0s(indices);
for kNbrOfPitches = indices
    y = y + signalData.yCell{kNbrOfPitches};
end

% Estimate with PEBSI-Lite
fmin = 90;
fmax = 1000;
fk_est = pebsi_lite_selfreg(y,signalData.fs,fmin,fmax);

fprintf('True fundamental frequencies:\n %s\n\n',mat2str(sort(trueF0s(:))',6))
fprintf('Estimated fundamental frequencies:\n %s\n\n',mat2str(sort(fk_est(:))',6))


