function w_rls = rls_update(w_old,R,r,Lmax,rls_lambda)
% Smooth update of the filter coefficients to counter the bias induced by
% the sparse penalty.
%
P = length(w_old)/Lmax;
w_rls = w_old;
lambdaI = rls_lambda*eye(Lmax);
for kPitch = 1:P
    tempIndices = (kPitch-1)*Lmax+1:kPitch*Lmax;
    if kPitch == 1
        otherIndices = kPitch*Lmax+1:P*Lmax;
    elseif kPitch==P
        otherIndices = 1:(P-1)*Lmax;
    else
        otherIndices = [1:(kPitch-1)*Lmax,(kPitch*Lmax+1:P*Lmax)];
    end
    
    Rtemp = R(tempIndices,:);
    Rq = Rtemp(:,otherIndices);
    Rp = Rtemp(:,tempIndices);
    
    rp = r(tempIndices);
    rp = rp - Rq*w_rls(otherIndices);
    
    R_tilde = Rp + lambdaI;
    r_tilde = rp + rls_lambda*w_rls(tempIndices);
    
    w_rls(tempIndices) = R_tilde \ r_tilde;
end
end