function w_out = proximal_gradient_update(w_in,Rn,rn,P,Lmax,gamma,gamma2,maxIter,stepSize)
%
w_ell = w_in;
first_harm_amps = ones(P,1);
for ell = 1:maxIter
    % Gradient step
    tempGradient = -rn + Rn*w_ell;
    r_ell = w_ell - stepSize*tempGradient;
    r_ell = soft_threshold( r_ell,gamma*stepSize);
    % Projection
    for kBlock = 1:P
        tempIndices = (kBlock-1)*Lmax+1:kBlock*Lmax;
        temp_w = r_ell(tempIndices);
        gamma2Temp = gamma2*max(1,min(1000,1/(abs(first_harm_amps(kBlock))+1e-5)));
        temp = max(norms(temp_w,2) - gamma2Temp*stepSize^2,0);
        w_ell(tempIndices) = temp/(temp+gamma2Temp*stepSize^2)*temp_w;
    end
    first_harm_amps = w_ell(1:Lmax:P*Lmax);
end
w_out = w_ell;

end

function z = soft_threshold(x,gamma)
tempZ = max(abs(x)-gamma,0);
z = tempZ./(tempZ+gamma).*x;
end