function f0 = interval_search_anls(x,L,f0lim,fs,nfft)
% Approximate non-linear least squares to update pitch frequencies.

if nargin<5
    nfft = 2^20;
end
freqVec = (0:nfft-1)/nfft*fs;
N = length(x);

a = find(freqVec>=f0lim(1),1,'first');
b = find(freqVec<=f0lim(2),1,'last');
m = floor((a+b)/2);
lambda = m-1;
mu = m+1;
tol = 3;
counter = 0;
while b-a > tol
    Flambda = F(x,N,nfft,lambda,L);
    Fmu = F(x,N,nfft,mu,L);
    if Flambda > Fmu
        b = mu;
    else
       a = lambda; 
    end
    m = floor((a+b)/2);
    lambda = m-1;
    mu = m+1;
    counter = counter+1;
end
f0 = freqVec(floor((a+b)/2));
end

function val = F(x,N,nfft,k,L)
val = 0;
for kHarmonic=1:L
   if kHarmonic == 1
       val = val + abs(exp(-2i*pi*k*kHarmonic/nfft*(0:N-1))*x)^2;
   else
       val = val + abs(exp(-2i*pi*k*kHarmonic/nfft*(0:N-1))*x)^2;
   end
end
end