function [ANew,AInnerNew,AInnerNoPhaseNew,AOldNew,fpgridNew,w_hat,changeFlag] = ...
    dictionaryUpdate(w_hat,refSignal,pitchLimit,A,AInner,AInnerNoPhase,fpgrid,t,fs,Lmax,P,...
    dictionaryLength,startIndexTime,stopIndexTime,currIndexCurrA,startIndexCurrA,stopIndexCurrA,AOld,startIndexOldA)
%
% Update the pitch frequency grid.


changeFlag = 0;
w_reshape = reshape(w_hat,Lmax,P);
w_norms = norms(w_reshape,2,1);

ANew = [];
AInnerNew =[];
AInnerNoPhaseNew = [];
AOldNew = [];
fpgridNew = [];


tTemp = t(startIndexTime:stopIndexTime);
nbrTimePoints = length(tTemp);
if isempty(AOld)
    % we can estimate based on the current dictionary, do not need the old
    % one
    AEstimation =  A(startIndexCurrA:currIndexCurrA,:);
    changeIndicesCurrA = startIndexCurrA:stopIndexCurrA;
    indexForCurrentA = 1; % first index in resulting estimated matrix
else
    % due to overlap, we need to use parts of the old A
    AEstimation =  [AOld(startIndexOldA:end,:);...
        A(1:currIndexCurrA,:)];
    changeIndicesCurrA = startIndexCurrA:stopIndexCurrA;
    indexForCurrentA = nbrTimePoints - length(startIndexCurrA:stopIndexCurrA)+1;
    indexForOldA = indexForCurrentA-1;
end

% Find the biggest present pitch -> the one to modify
[tempM,tempIndices] = findpeaks(w_norms);
[tempM,im] = sort(tempM,'descend');
tempIndices = tempIndices(im);
% Keep only big peaks
tempIndices = tempIndices(tempM>=0.05*max(tempM)); % 0.3

if isempty(tempIndices)
    return
end

for kPitch=1:length(tempIndices)
    biggestF0Index = tempIndices(kPitch);
    
    maxHarmAmp = max(abs(w_reshape(:,biggestF0Index)));
    nzHarmonics = find(abs(w_reshape(:,biggestF0Index))>.2*maxHarmAmp)';
    
    pitchInt = [fpgrid(biggestF0Index)-pitchLimit,fpgrid(biggestF0Index)+pitchLimit]/fs*2*pi;
    
    newGridPoint = interval_search_anls(refSignal,max(nzHarmonics),pitchInt*fs/2/pi,fs);
    if isempty(newGridPoint)
        continue
    end
    
    
    changeFlag = 1;
    fpgrid(biggestF0Index) = newGridPoint;
    
    % get indices corresponding to harmonics
    harmonicIndices = (biggestF0Index-1)*Lmax+1:biggestF0Index*Lmax;
    
    AInnerNoPhaseTemp = 2*pi*tTemp'*newGridPoint*(1:Lmax)/fs;
    AInnerTemp = phaseUpdate(refSignal,AInnerNoPhaseTemp,1,length(refSignal),1,Lmax,Lmax);
    ATemp = exp(1i*AInnerTemp);
    
    %%%%%%%%%%%%%% Update A %%%%%%%%%%%%%%%%%%%
    tempIndexUpdate =  indexForCurrentA+length(changeIndicesCurrA)-1;
    AInnerNoPhase(changeIndicesCurrA,harmonicIndices) = AInnerNoPhaseTemp(indexForCurrentA:tempIndexUpdate,:);
    AInner(changeIndicesCurrA,harmonicIndices) = AInnerTemp(indexForCurrentA:tempIndexUpdate,:);
    A(changeIndicesCurrA,harmonicIndices) = ATemp(indexForCurrentA:tempIndexUpdate,:);
    if ~isempty(AOld)
        AOld(startIndexOldA:end,harmonicIndices) = ATemp(1:indexForOldA,:);
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
end
% Assign modified variables

ANew = A;
AInnerNew = AInner;
AInnerNoPhaseNew = AInnerNoPhase;
AOldNew = AOld;
fpgridNew = fpgrid;
end

